maze_position = { row = 1, col = 1 };
local arrow_out_alpha = 0.7;
local arrow_over_alpha = 1;

function get_maze_label(pos)
	return "maze_" .. pos.row .. "_" .. pos.col;
end

function turn_arrow_on(arrow_spec)
	if not scene[arrow_spec.name] then
		scene:Spawn(arrow_spec);
	end
	
	scene[arrow_spec.name]:SetAlpha(arrow_out_alpha);
	scene[arrow_spec.name]:LoadZone("quest/m3_maze_shared/" .. string.lower(arrow_spec.name));
	
	-- offset the arrows for Flo's screen position
	local arrow_pos = { x = 0, y = 0 };
	local flo_screen_pos = scene.FLO:GetScreenPosition();
	local flo_desired_screen_pos = { x = 400, y = 300 } -- centre of screen
	arrow_pos.x = flo_screen_pos.x - flo_desired_screen_pos.x;
	arrow_pos.y = flo_screen_pos.y - flo_desired_screen_pos.y;
	
	scene[arrow_spec.name]:JumpToPoint(arrow_pos);
end

function turn_arrow_off(arrow_spec)
	if not scene[arrow_spec.name] then
		scene:Spawn(arrow_spec);
	end
	
	scene[arrow_spec.name]:DumpZone();
	scene[arrow_spec.name]:SetAlpha(0);
end

function hide_arrows()
	turn_arrow_off(arrow_north_spec);
	turn_arrow_off(arrow_east_spec);
	turn_arrow_off(arrow_south_spec);
	turn_arrow_off(arrow_west_spec);
end

function show_arrows()
	local mazeLabel = get_maze_label(maze_position);
	mazeLabel = mazeLabel .. "_";
	local vertLabel = scene.mesh:FindVertLabel(mazeLabel);
	local dirArray = string.gsub(vertLabel, mazeLabel, "", 1);
	--scene.DEBUG_OUT:SayRaw(dirArray);
	
	local north = string.sub(dirArray, 1, 1) == "1";
	local east = string.sub(dirArray, 2, 2) == "1";
	local south = string.sub(dirArray, 3, 3) == "1";
	local west = string.sub(dirArray, 4, 4) == "1";
	
	if north then turn_arrow_on(arrow_north_spec) else turn_arrow_off(arrow_north_spec) end
	if east then turn_arrow_on(arrow_east_spec) else turn_arrow_off(arrow_east_spec) end
	if south then turn_arrow_on(arrow_south_spec) else turn_arrow_off(arrow_south_spec) end
	if west then turn_arrow_on(arrow_west_spec) else turn_arrow_off(arrow_west_spec) end
end

function goto_new_maze_position(flo)
	flo:SetMode(MODE.CUTSCENE);
	hide_arrows();
	local defaultCameraMargin = { x = 0, y = 0}; --scene:GetCameraMargin();
	scene:SetCameraMargin { x = 400, y = 300 };
	local maze_label = get_maze_label(maze_position);
	maze_label = maze_label .. "_";
	local label = scene.mesh:FindVertLabel(maze_label);
	--coroutine.yield(RESUME.NOW);
	--scene.DEBUG_OUT:SayRaw(label);
	
	flo:WalkTo(label);
	wait_walkto(scene.FLO);
	
	show_arrows();
	scene:SetCameraMargin(defaultCameraMargin);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function arrow_command(actor)
	actor:SetAlpha(0);
	actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
	actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	actor:LoadImage(string.lower(actor.name));
	actor.delta = { row = 0, col = 0 };
	
	if actor.name == "ARROW_NORTH" then
		actor.delta.row = -1;
	elseif actor.name == "ARROW_EAST" then
		actor.delta.col = 1;
	elseif actor.name == "ARROW_SOUTH" then
		actor.delta.row = 1;
	else -- ARROW_WEST;
		actor.delta.col = -1;
	end
	
	actor.on_click = arrow_click;
	actor.point_at_fn = arrow_point_at_fn;
end

function arrow_click(flo, actor)
	local maze_label = "";
	while maze_label == "" do
		maze_position.row = maze_position.row + actor.delta.row;
		maze_position.col = maze_position.col + actor.delta.col;
		maze_label = scene.mesh:FindVertLabel(get_maze_label(maze_position));
	end
	flo:StartProc(goto_new_maze_position);
	return RESPONSE.IGNORE;
end

function arrow_point_at_fn(actor, enter)
	if scene.FLO:GetMode() ~= MODE.CUTSCENE then
		if enter then
			actor:SetAlpha(arrow_over_alpha);
		else
			actor:SetAlpha(arrow_out_alpha);
		end
	end
end

arrow_north_spec = 
{
	name = "ARROW_NORTH";
	command = arrow_command;
}

arrow_east_spec = 
{
	name = "ARROW_EAST";
	command = arrow_command;
}

arrow_south_spec = 
{
	name = "ARROW_SOUTH";
	command = arrow_command;
}

arrow_west_spec = 
{
	name = "ARROW_WEST";
	command = arrow_command;
}